;; This example shows a simple raster using the CPC+ 
;; extended palette, and using the CPC+ programmable 
;; raster interrupts to define the position of the raster 
;; on the display.
;;
;; This example is designed for CPC+ only and will
;; not work on the CPC or KC Compact.
;;
;; This example will compile with the MAXAM assembler
;; or the built-in assembler of WinAPE32.

.scr_set_mode equ &bc0e


org &8000
nolist

;;--------------------------------------------------
;; clear screen

ld a,1
call scr_set_mode


;;--------------------------------------------------
;; STEP 1 -  Unlock CPC+ additional features

di
ld b,&bc
ld hl,sequence
ld e,17
.seq 
ld a,(hl)
out (c),a
inc hl
dec e
jr nz,seq
ei

;;----------------------------------------------------------
;; STEP 2 - Install a interrupt handler

;; disable interrupts
di
;; interrupt mode 1 (call to interrupt handler at &0038)
im 1

;; &c9 corresponds to the opcode RET
;; &fb corresponds to the opcode EI
;;
;; RET opcode takes 3us, EI opcode takes 1us

;; write EI,RET to interrupt handler at &0038
ld hl,&c9fb
ld (&0038),hl

;; enable interrupts
ei

;;----------------------------------------------------------
;; STEP 3 -  Initialise CPC+ Programmable Raster Interrupt

;; disable interrupts
di

;; page-in asic registers to &4000-&7fff
ld bc,&7fb8					
out (c),c					


ld a,100						;; line 100
ld (&6800),a					;; set line

;; page-out asic registers
ld bc,&7fa0
out (c),c

;; enable interrupts
ei


;;------------------------------------------------------------

.main_loop
;; wait for interrupt
halt

;; delay so that colour change is hidden by border
defs 16

;; page-in asic registers to &4000-&7fff
ld bc,&7fb8					;; [3]
out (c),c					;; [4]

;; address of pen 0 in CPC+ ASIC registers
ld de,&6400					;; [3]

;; start of table
ld hl,raster_colours		;; [3]

;; number of colours in table*2
ld b,end_raster_colours-raster_colours   ;; [2]
;; /2
srl b

.rl
;; read colour from table (a byte at a time)
;; write colour to ASIC colour palette (a byte at a time)
ld a,(hl)					;; [2]
ld (de),a					;; [2]
inc hl						;; [2]
inc e						;; [1]
ld a,(hl)					;; [2]
ld (de),a					;; [2]
inc hl						;; [2]
dec e						;; [1]

;; delay so that the next colour change occurs
;; immediatly below this colour change
defs 64-2-2-2-1-2-2-2-1-1-3

dec b						;; [1]
jp nz,rl					;; [3]

;; page-out asic registers
ld bc,&7fa0
out (c),c

jp main_loop

;;---------------------------------------------

;; - there is two bytes per colour.
;; - these are stored in a form that can be written direct 
;; to the CPC+ colour palette registers
.raster_colours
defw &0001
defw &0004
defw &0008
defw &000d
defw &000f
defw &000d
defw &0008
defw &0004
defw &0001
defw &0000
.end_raster_colours

;;----------------------------------------------------------
;; this is the sequence to unlock the ASIC extra features
.sequence
defb &ff,&00,&ff,&77,&b3,&51,&a8,&d4,&62,&39,&9c,&46,&2b,&15,&8a,&cd,&ee